/****** Object:  Trigger [TRG_RC_CREDIARIO_PARC_PDV_PEND] Script Date: 01/14/2014 17:29:43 ******/
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_RC_CREDIARIO_PARC_PDV_PEND]'))
DROP TRIGGER [dbo].[TRG_RC_CREDIARIO_PARC_PDV_PEND]
GO 
CREATE TRIGGER [dbo].[TRG_RC_CREDIARIO_PARC_PDV_PEND] ON [dbo].[RC_CREDIARIO_PARC] AFTER INSERT,UPDATE,DELETE
AS
BEGIN
	--INSERTS E UPDATES 
	INSERT INTO RC_DEB_CLI_PDV_PEND
		(CD_EMP,
		CD_CLI)
	SELECT	
		CD_EMP,
		CD_CLI	
	FROM 
		INSERTED I 
	WHERE NOT EXISTS (SELECT 
						CD_CLI 
					  FROM 
						RC_DEB_CLI_PDV_PEND P 
					   WHERE 
							P.CD_EMP = I.CD_EMP AND 
							P.CD_CLI = I.CD_CLI) 
	GROUP BY 
		CD_EMP,
		CD_CLI
	--DELETEDS
	IF @@ROWCOUNT = 0
	BEGIN
		INSERT INTO RC_DEB_CLI_PDV_PEND
		(CD_EMP,CD_CLI)
		SELECT	
			CD_EMP,
			CD_CLI	
		FROM 
			DELETED D 
		WHERE NOT EXISTS (SELECT 
							CD_CLI 
						FROM 
							RC_DEB_CLI_PDV_PEND P 
						WHERE 
							P.CD_EMP = D.CD_EMP AND 
							P.CD_CLI = D.CD_CLI) 
		GROUP BY 
			CD_EMP,
			CD_CLI
	END



	--INSERTS E UPDATES 
	INSERT INTO RC_DEB_CLI_PDV_PEND (CD_EMP,CD_CLI)
	SELECT	
		INSERTED.CD_EMP,
		INSERTED.CD_CLI	
	FROM 
		INSERTED 
		INNER JOIN RC_CLI_CREDIARIO ON 
		INSERTED.CD_EMP = RC_CLI_CREDIARIO.CD_EMP  AND 
		INSERTED.CD_CLI = RC_CLI_CREDIARIO.CD_CLI 
		
		INNER JOIN RC_MDL_VENDA ON 
		RC_CLI_CREDIARIO.CD_EMP		=RC_MDL_VENDA.CD_EMP AND 
		RC_CLI_CREDIARIO.CD_MDL_VD	=RC_MDL_VENDA.CD_MDL_VD

	WHERE 
		NOT EXISTS (SELECT 
							CD_CLI 
						FROM 
							RC_DEB_CLI_PDV_PEND P 
						WHERE 
							P.CD_EMP = INSERTED.CD_EMP 
							AND P.CD_CLI = INSERTED.CD_CLI) 
		AND RC_MDL_VENDA.TP_FECHA<>4
	GROUP BY 
		INSERTED.CD_EMP,
		INSERTED.CD_CLI;

	
	--DELETEDS
	IF @@ROWCOUNT = 0
	BEGIN
		INSERT INTO RC_DEB_CLI_PDV_PEND (CD_EMP,CD_CLI)
		SELECT	
			DELETED.CD_EMP,
			DELETED.CD_CLI	
		FROM 
			DELETED 
			
			INNER JOIN RC_CLI_CREDIARIO ON 
			DELETED.CD_EMP = RC_CLI_CREDIARIO.CD_EMP  AND 
			DELETED.CD_CLI = RC_CLI_CREDIARIO.CD_CLI 

			INNER JOIN RC_MDL_VENDA ON 
			RC_CLI_CREDIARIO.CD_EMP=RC_MDL_VENDA.CD_EMP AND 
			RC_CLI_CREDIARIO.CD_MDL_VD=RC_MDL_VENDA.CD_MDL_VD
		WHERE 
			NOT EXISTS (SELECT 
								CD_CLI 
							FROM 
								RC_DEB_CLI_PDV_PEND P 
							WHERE 
								P.CD_EMP = DELETED.CD_EMP 
								AND P.CD_CLI = DELETED.CD_CLI) 
			AND RC_MDL_VENDA.TP_FECHA<>4
		GROUP BY 
			DELETED.CD_EMP,
			DELETED.CD_CLI
	END


END
GO


